clear;

% set parameters
P = [.94 .05 .01 .00; .03 .94 .02 .01; .05 .14 .80 .01; .05 .15 .30 .50];
mu = [.25;.25;.25;.25]; 

% X takes values in 0:3
% I = X+1 takes values in 0:4
% Y takes values in 0:infty

% simulate N values of X
N=50;
I = zeros(N,1);
eps = rand(N,1);
I(1) = find(cumsum(mu)>=eps(1),1);
CDF = cumsum(P,2);
for i=2:N
   I(i) = find(CDF(I(i-1),:)>= eps(i),1); 
end
X = I-1;

% simulate N values of Y
lambda = @(x) 50-10*x;
gamma = @(x,y) lambda(x).^y .* exp(1-lambda(x));
Gamma = @(y) diag([gamma(0,y),gamma(1,y),gamma(2,y),gamma(3,y)]);
Y = poissrnd(lambda(X));

% calculate filtering distributions pi and normalization constants c
pi = zeros(N,4);
c = zeros(N);
c(1) = sum(Gamma(Y(1))*mu);
pi(1,:) = Gamma(Y(1))*mu/c(1);
for k=2:N
    pi(k,:) = Gamma(Y(k))*P'*pi(k-1,:)';
    c(k) = sum(pi(k,:));
    pi(k,:) = pi(k,:)/c(k);
end

% calculate smoothing distributions sigma
beta = zeros(N,4);
sigma = zeros(N,4);
beta(N,:) = ones(4,1)/c(N);
sigma(N,:) = pi(N,:);
for k=(N-1):-1:1
    beta(k,:) = P*Gamma(Y(k+1))*beta(k+1,:)'/c(k);
    sigma(k,:) = diag(pi(k,:))*P*Gamma(Y(k+1))*diag(beta(k+1,:))*ones(4,1);
end

% calculate maximum likelihood estimators Xhat of X 
[M,Ihat] = max(sigma,[],2);
Xhat = Ihat - 1;

% Viterbi value function v, optimal control b, optimal path Xtilde
v = zeros(N,4);
b = zeros(N,1);
v(1,:) = log(mu)' + log(gamma(0:3,Y(1)));
for k = 2:N
    for i = 1:4
        [m,j] = max(v(k-1,:)'+log(P(:,i)));
        b(k,i) = j;
        v(k,i) = m + log(gamma(i-1,Y(k)));
    end
end
Itilde = zeros(N,1);
[m,j] = max(v(N,:));
Itilde(N) = j;
for k = (N-1):-1:1
    Itilde(k) = b(k+1,Itilde(k+1));
end
Xtilde = Itilde - 1; 

% plot
figure(); 
subplot(2,1,1);
hold on;
plot(X,'kx');
plot(Xhat+.1,'bx');
plot(Xtilde+.2,'gx');
axis([0 N+1 0 3.5]);
hold off;
subplot(2,1,2);
hold on;
bar(1:N,Y(1:N));
for x = 0:3
    plot([1 N],[lambda(x) lambda(x)],'k--')
end
axis([0 N+1 0 inf]);
hold off;

% save('fret.mat','X','Y','pi')