clear;

% X takes values in 0:3
% Y takes values in 0:infty

% X is a Markov process with transition matrix P and initial distribution mu0
P = [.94 .05 .01 .00; .03 .94 .02 .01; .05 .14 .80 .01; .05 .15 .30 .50];
mu0 = [.25;.25;.25;.25];

% Y is Poisson distributed with rate lambda(X)
lambda = @(x) 50-10*x;

% number of observations
n = 50;

% simulate a trajectory of X AND Y
X = zeros(n,1);
Y = zeros(n,1);
% REPLACE THIS BY YOUR CODE
load('fret.mat','X','Y');
% END REPLACE

% calculate the smoothing distributions pi 
pi = zeros(n,4);
% REPLACE THIS BY YOUR CODE
load('fret.mat','pi');
% END REPLACE 

% calculate the maximum likelihood estimator Xhat of X 
[M,Xhat] = max(pi,[],2);
Xhat = Xhat - 1;

% plot
figure(); 
subplot(2,1,1);
hold on;
plot(X,'kx'); 
plot(Xhat+.1,'bx'); 
axis([0 n+1 0 3.5]);
legend('True state X','Estimated state Xhat');
title('Number of Binding Proteins (Hidden State X)');
hold off;
subplot(2,1,2);
hold on;
bar(1:n,Y(1:n));
for x = 0:3
    plot([1 n],[lambda(x) lambda(x)],'k--')
end
axis([0 n+1 0 inf]);
title('Photon Counts (Observations Y)');
hold off;